# Radioss Anim to VTKHDF format converter

> Conversion script from OpenRadioss Anim format to VTKHDF.

This Python script allows conversion of [OpenRadioss](https://openradioss.org/) shock simulator Anim output files to the VTKHDF format, usable directly by ParaView. It allows converting multiple time steps into a single optimised file, wrapping the VTK PartitionedDataSetCollection format. The Anim reader is based on the official [Anim to VTK legacy format converter](https://github.com/OpenRadioss/OpenRadioss/blob/main/tools/anim_to_vtk/src/anim_to_vtk.cpp) from the OpenRadioss repository.

## Usage

This module requires Python 3.10+. First, create a virtualenv and activate it.

On Linux, you can do the following:

```bash
python -m venv .venv
source .venv/bin/activate
```

Otherwise, you can refer to the [Python venv documentation](https://docs.python.org/3/library/venv.html#how-venvs-work) for instructions on how to activate your virtual environment. 

Then, install the Python module, and run the script to convert files from the OpenRadioss format to VTKHDF.

```bash
python -m pip install .
python -m animtovtkhdf [-h] [-q] [-n] [infiles ...] outfile
```

Positional arguments:
 - `infiles`         input files to convert. All files must be part of a same time series, and have the same fields
 - `outfile`         output file

Options:
 - `-h`, `--help`      show this help message and exit
 - `-q`, `--quiet`     do not show the conversion operation details
 - `-n`, `--nostatic`  do not write cells as static. Use when the connectivity does not change between time steps. If not set, only points and field values will be changed at
                  each timestep.

## Development

Install in dev mode and run the module tests.

```bash
pip install -e '.[dev]'
python -m pytest testing/
python -m animtovtkhdf <input Anim file(s)> <output VTKHDF file>
```

# License
This repository is under the Apache 2.0 license, see NOTICE and LICENSE file.
