# Tutorial Creation Guidelines

We are super excited to see new tutorials and playground coming in from our community!


Here are the guidelines for tutorial creation, which we kindly ask to adhere to:
- For every tutorial, please create a subfolder
- Add all necessary dependencies to the `requirements.txt` in this folder, which are not in the `pandaset` python package. We would like to keep the Devkit dependencies _lean_, but can add anything we need to the tutorial requirements.txt
- If you think your code contains methods that should rather be part of the data set objects from the Devkit, feel free to add a PR for it, too, so we can review and decide where to best place it.
- Add markdown cells between code cells, or at least use code comments so that everyone in the community can follow your steps.


If you have other tutorials with other dependencies or build systems (for ex: Docker), feel free to include them in your tutorial's subfolder including a README.md for build instructions.


