#! /bin/bash

root_dir=$(cd ..; pwd)
install_dir=${root_dir}/install
superbuild_build_dir=${root_dir}/cmake-build-Superbuild

if [ ! -d ${superbuild_build_dir} ]
then
   mkdir ${superbuild_build_dir}
fi 

check_status_code() {
   if [ $1 -ne 0 ]
   then
	echo "[Superbuild] Failure. Exiting."
	exit 1
   fi
}

cd ${superbuild_build_dir} || (echo "Failed to go in ${superbuild_build_dir}" && exit)
cmake ../Superbuild -DCMAKE_BUILD_TYPE=Release -DSUPERBUILD_INSTALL_DIR=${install_dir}
check_status_code $?
# cmake --build . --config Release
cmake --build . --config Release --target install
check_status_code $?

popd
