/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkDirect3DShader.h"
#include "vtkObjectFactory.h"
#include "vtkDirect3DConstantBufferObject.h"
#include "vtkDirect3DRenderWindow.h"

vtkStandardNewMacro(vtkDirect3DShader)

vtkDirect3DShader::vtkDirect3DShader()
{
  this->ShaderType = vtkDirect3DShader::Unknown;
  this->ConstantBuffer = vtkDirect3DConstantBufferObject::New();
  this->Context = NULL;
}


vtkDirect3DShader::~vtkDirect3DShader()
{
  this->ConstantBuffer->Delete();
}

void vtkDirect3DShader::BindConstantBuffer()
{
  if (this->ConstantBuffer->GetNumberOfConstants())
  {
    this->ConstantBuffer->Bind();
    ID3D11Buffer *vb = this->ConstantBuffer->GetBuffer();
    if (this->ShaderType == vtkDirect3DShader::Vertex)
    {
      this->Context->GetImmediateContext()->VSSetConstantBuffers(0, 1, &vb);
    }
    else if (this->ShaderType == vtkDirect3DShader::Fragment)
    {
      this->Context->GetImmediateContext()->PSSetConstantBuffers(1, 1, &vb);
    }
  }
}

void vtkDirect3DShader::SetType(Type type)
{
  this->ShaderType = type;
}

void vtkDirect3DShader::SetContext(vtkDirect3DRenderWindow *rw)
{
  this->ConstantBuffer->SetContext(rw);
  this->Context = rw;
}

void vtkDirect3DShader::SetSource(const std::string &source)
{
  this->Source = source;
}

// ----------------------------------------------------------------------------
void vtkDirect3DShader::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);
}
