/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDirect3DRenderPass.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkDirect3DRenderPass.h"

#include "vtkInformation.h"
#include "vtkInformationObjectBaseVectorKey.h"
#include "vtkObjectFactory.h"
#include "vtkProp.h"
#include "vtkRenderState.h"

#include <cassert>

vtkInformationKeyMacro(vtkDirect3DRenderPass, RenderPasses, ObjectBaseVector)

//------------------------------------------------------------------------------
void vtkDirect3DRenderPass::PrintSelf(std::ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

//------------------------------------------------------------------------------
bool vtkDirect3DRenderPass::ReplaceShaderValues(std::string &, std::string &,
                                              std::string &,
                                              vtkAbstractMapper *, vtkProp *)
{
  return true;
}

//------------------------------------------------------------------------------
bool vtkDirect3DRenderPass::SetShaderParameters(vtkShaderProgram *,
                                              vtkAbstractMapper *, vtkProp *)
{
  return true;
}

//------------------------------------------------------------------------------
vtkMTimeType vtkDirect3DRenderPass::GetShaderStageMTime()
{
  return 0;
}

//------------------------------------------------------------------------------
vtkDirect3DRenderPass::vtkDirect3DRenderPass()
{
}

//------------------------------------------------------------------------------
vtkDirect3DRenderPass::~vtkDirect3DRenderPass()
{
}

//------------------------------------------------------------------------------
void vtkDirect3DRenderPass::PreRender(const vtkRenderState *s)
{
  assert("Render state valid." && s);
  size_t numProps = s->GetPropArrayCount();
  for (size_t i = 0; i < numProps; ++i)
  {
    vtkProp *prop = s->GetPropArray()[i];
    vtkInformation *info = prop->GetPropertyKeys();
    if (!info)
    {
      info = vtkInformation::New();
      prop->SetPropertyKeys(info);
      info->FastDelete();
    }
    info->Append(vtkDirect3DRenderPass::RenderPasses(), this);
  }
}

//------------------------------------------------------------------------------
void vtkDirect3DRenderPass::PostRender(const vtkRenderState *s)
{
  assert("Render state valid." && s);
  size_t numProps = s->GetPropArrayCount();
  for (size_t i = 0; i < numProps; ++i)
  {
    vtkProp *prop = s->GetPropArray()[i];
    vtkInformation *info = prop->GetPropertyKeys();
    if (info)
    {
      info->Remove(vtkDirect3DRenderPass::RenderPasses(), this);
      if (info->Length(vtkDirect3DRenderPass::RenderPasses()) == 0)
      {
        info->Remove(vtkDirect3DRenderPass::RenderPasses());
      }
    }
  }
}
