/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDirect3DProperty.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkDirect3DProperty
 * @brief   Direct3D property
 *
 * vtkDirect3DProperty is a concrete implementation of the abstract class
 * vtkProperty. vtkDirect3DProperty interfaces to the Direct3D rendering library.
*/

#ifndef vtkDirect3DProperty_h
#define vtkDirect3DProperty_h

#include "vtkRenderingDirect3DModule.h" // For export macro
#include "vtkProperty.h"

class VTKRENDERINGDIRECT3D_EXPORT vtkDirect3DProperty : public vtkProperty
{
public:
  static vtkDirect3DProperty *New();
  vtkTypeMacro(vtkDirect3DProperty, vtkProperty);
  void PrintSelf(ostream& os, vtkIndent indent) VTK_OVERRIDE;

  /**
   * Implement base class method.
   */
  void Render(vtkActor *a, vtkRenderer *ren);

  /**
   * Implement base class method.
   */
  void BackfaceRender(vtkActor *a, vtkRenderer *ren);

  /**
   * This method is called after the actor has been rendered.
   * Don't call this directly. This method cleans up
   * any shaders allocated.
   */
  virtual void PostRender(vtkActor *a,
                          vtkRenderer *r);

  /**
   * Release any graphics resources that are being consumed by this
   * property. The parameter window could be used to determine which graphic
   * resources to release.
   */
  virtual void ReleaseGraphicsResources(vtkWindow *win);

protected:
  vtkDirect3DProperty();
  ~vtkDirect3DProperty();

  /**
   * Method called in vtkDirect3DProperty::Render() to render textures.
   * Last argument is the value returned from RenderShaders() call.
   */
  bool RenderTextures(vtkActor* actor, vtkRenderer* renderer);

private:
  vtkDirect3DProperty(const vtkDirect3DProperty&) VTK_DELETE_FUNCTION;
  void operator=(const vtkDirect3DProperty&) VTK_DELETE_FUNCTION;
};

#endif
