/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDirect3DProperty.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkDirect3DRenderer.h"
#include "vtkDirect3DProperty.h"

#include "vtkDirect3DHelper.h"

#include "vtkObjectFactory.h"
//#include "vtkDirect3DTexture.h"
#include "vtkTexture.h"

#include <cassert>

vtkStandardNewMacro(vtkDirect3DProperty);

vtkDirect3DProperty::vtkDirect3DProperty()
{
}

vtkDirect3DProperty::~vtkDirect3DProperty()
{
}


// ----------------------------------------------------------------------------
// Implement base class method.
void vtkDirect3DProperty::Render(vtkActor *anActor, vtkRenderer *ren)
{

  this->RenderTextures(anActor, ren);
  this->Superclass::Render(anActor, ren);
}

//-----------------------------------------------------------------------------
bool vtkDirect3DProperty::RenderTextures(vtkActor*, vtkRenderer* ren)
{
  // render any textures.
  int numTextures = this->GetNumberOfTextures();
  for (int t = 0; t < numTextures; t++)
  {
    this->GetTextureAtIndex(t)->Render(ren);
  }


  return (numTextures > 0);
}

//-----------------------------------------------------------------------------
void vtkDirect3DProperty::PostRender(vtkActor *actor, vtkRenderer *renderer)
{

  this->Superclass::PostRender(actor, renderer);

}

//-----------------------------------------------------------------------------
// Implement base class method.
void vtkDirect3DProperty::BackfaceRender(vtkActor *vtkNotUsed(anActor), vtkRenderer *vtkNotUsed(ren))
{
}

//-----------------------------------------------------------------------------
void vtkDirect3DProperty::ReleaseGraphicsResources(vtkWindow *win)
{
  // release any textures.
  int numTextures = this->GetNumberOfTextures();
  if (numTextures > 0)
  {
    for (int i = 0; i < numTextures; i++)
    {
      this->GetTextureAtIndex(i)->ReleaseGraphicsResources(win);
    }
  }

  this->Superclass::ReleaseGraphicsResources(win);
}

//----------------------------------------------------------------------------
void vtkDirect3DProperty::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);

}
