/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkDirect3DHelper_h
#define vtkDirect3DHelper_h

#include "vtkRenderingDirect3DModule.h" // for export macro
#include "vtkTimeStamp.h"

class vtkDirect3DIndexBufferObject;
#include <windows.h>  // used for ivars
#include <d3d11_1.h>  // used for ivars

class vtkDirect3DShaderCache;
class vtkDirect3DVertexArrayObject;
class vtkDirect3DShaderProgram;
class vtkWindow;
class vtkDirect3DRenderWindow;


// Store the shaders, program, and ibo in a common place
// as they are used together frequently.  This is just
// a convenience class.
class VTKRENDERINGDIRECT3D_EXPORT vtkDirect3DHelper
{
public:
  vtkDirect3DShaderProgram *Program;
  vtkTimeStamp ShaderSourceTime;
  ID3D11InputLayout*  VertexLayout;
  vtkTimeStamp AttributeUpdateTime;

  vtkDirect3DIndexBufferObject *IBO;

  vtkDirect3DHelper();
  ~vtkDirect3DHelper();
  void ReleaseGraphicsResources(vtkWindow *win);
  void SetContext(vtkDirect3DRenderWindow *);
};

#endif // vtkDirect3DHelper_h

// VTK-HeaderTest-Exclude: vtkDirect3DHelper.h
