/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkDirect3DHelper.h"

#include "vtkDirect3DIndexBufferObject.h"
#include "vtkDirect3DRenderWindow.h"
#include "vtkDirect3DShaderProgram.h"

vtkDirect3DHelper::vtkDirect3DHelper()
{
  this->Program = NULL;
  this->IBO = vtkDirect3DIndexBufferObject::New();
  this->VertexLayout = NULL;
}

vtkDirect3DHelper::~vtkDirect3DHelper()
{
  this->IBO->Delete();
  if (this->VertexLayout)
  {
    this->VertexLayout->Release();
    this->VertexLayout = NULL;
  }
}

void vtkDirect3DHelper::SetContext(vtkDirect3DRenderWindow * win)
{
  this->IBO->SetContext(win);
}

void vtkDirect3DHelper::ReleaseGraphicsResources(vtkWindow * win)
{
  vtkDirect3DRenderWindow *rwin =
   vtkDirect3DRenderWindow::SafeDownCast(win);
  if (rwin)
  {
    // Ensure that the context is current before releasing any
    // graphics resources tied to it.
    rwin->MakeCurrent();
  }

  if (this->VertexLayout)
  {
    this->VertexLayout->Release();
    this->VertexLayout = NULL;
  }

  if (this->Program)
  {
    // Let ShaderCache release the graphics resources as it is
    // responsible for creation and deletion.
    this->Program = 0;
  }
  this->IBO->ReleaseGraphicsResources();
}
