/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkDirect3DCamera
 * @brief   Direct3D camera
 *
 * vtkDirect3DCamera is a concrete implementation of the abstract class
 * vtkCamera.  vtkDirect3DCamera interfaces to the Direct3D rendering library.
*/

#ifndef vtkDirect3DCamera_h
#define vtkDirect3DCamera_h

#include "vtkRenderingDirect3DModule.h" // For export macro
#include "vtkCamera.h"

class vtkDirect3DRenderer;
class vtkMatrix3x3;
class vtkMatrix4x4;

class VTKRENDERINGDIRECT3D_EXPORT vtkDirect3DCamera : public vtkCamera
{
public:
  static vtkDirect3DCamera *New();
  vtkTypeMacro(vtkDirect3DCamera, vtkCamera);
  void PrintSelf(ostream& os, vtkIndent indent) VTK_OVERRIDE;

  /**
   * Implement base class method.
   */
  virtual void Render(vtkRenderer *ren);

  virtual void UpdateViewport(vtkRenderer *ren);

  virtual void GetKeyMatrices(vtkRenderer *ren, vtkMatrix4x4 *&WCVCMatrix,
    vtkMatrix3x3 *&normalMatrix, vtkMatrix4x4 *&VCDCMatrix, vtkMatrix4x4 *&WCDCMatrix);

protected:
  vtkDirect3DCamera();
  ~vtkDirect3DCamera();

  vtkMatrix4x4 *WCDCMatrix;
  vtkMatrix4x4 *WCVCMatrix;
  vtkMatrix3x3 *NormalMatrix;
  vtkMatrix4x4 *VCDCMatrix;
  vtkTimeStamp KeyMatrixTime;
  vtkRenderer *LastRenderer;

private:
  vtkDirect3DCamera(const vtkDirect3DCamera&) VTK_DELETE_FUNCTION;
  void operator=(const vtkDirect3DCamera&) VTK_DELETE_FUNCTION;
};

#endif
