/*=========================================================================

  Program:   Visualization Toolkit

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkDirect3DBufferObject.h"
#include "vtkObjectFactory.h"
#include "vtkDirect3DRenderWindow.h"

vtkStandardNewMacro(vtkDirect3DBufferObject)


vtkDirect3DBufferObject::vtkDirect3DBufferObject()
{
  this->Buffer = NULL;
}

vtkDirect3DBufferObject::~vtkDirect3DBufferObject()
{
  if (this->Buffer)
  {
    this->Buffer->Release();
    this->Buffer = NULL;
  }
}

void vtkDirect3DBufferObject::ReleaseGraphicsResources()
{
  if (this->Buffer)
  {
    this->Buffer->Release();
    this->Buffer = NULL;
  }
}

bool vtkDirect3DBufferObject::Bind()
{
  return true;
}

bool vtkDirect3DBufferObject::Release()
{
  return true;
}

bool vtkDirect3DBufferObject::UploadInternalWithBinding(
  const void *buffer, size_t size, D3D11_BIND_FLAG bindFlag)
{
  D3D11_BUFFER_DESC bd;
  ZeroMemory( &bd, sizeof(bd) );
  bd.Usage = D3D11_USAGE_DEFAULT;
  bd.ByteWidth = static_cast<UINT>(size);
  bd.BindFlags = bindFlag;
  bd.CPUAccessFlags = 0;
  D3D11_SUBRESOURCE_DATA InitData;
  ZeroMemory( &InitData, sizeof(InitData) );
  InitData.pSysMem = buffer;
  HRESULT hr = this->Context->GetD3DDevice()->CreateBuffer( &bd, &InitData, &this->Buffer );
  if( FAILED( hr ) )
  {
    this->Error = "Failed to create buffer.";
    return false;
  }

  return true;
}


//-----------------------------------------------------------------------------
void vtkDirect3DBufferObject::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
