/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDirect3DActor.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class   vtkDirect3DActor
 * @brief   Direct3D actor
 *
 * vtkDirect3DActor is a concrete implementation of the abstract class vtkActor.
 * vtkDirect3DActor interfaces to the Direct3D rendering library.
*/

#ifndef vtkDirect3DActor_h
#define vtkDirect3DActor_h

#include "vtkRenderingDirect3DModule.h" // For export macro
#include "vtkActor.h"

class vtkInformationIntegerKey;
class vtkDirect3DRenderer;
class vtkMatrix4x4;
class vtkMatrix3x3;

class VTKRENDERINGDIRECT3D_EXPORT vtkDirect3DActor : public vtkActor
{
public:
  static vtkDirect3DActor *New();
  vtkTypeMacro(vtkDirect3DActor, vtkActor);
  void PrintSelf(ostream& os, vtkIndent indent) VTK_OVERRIDE;

  /**
   * Actual actor render method.
   */
  void Render(vtkRenderer *ren, vtkMapper *mapper);

  void GetKeyMatrices(vtkMatrix4x4 *&WCVCMatrix, vtkMatrix3x3 *&normalMatrix);

  /**
   * If this key is set in GetPropertyKeys(), the glDepthMask will be adjusted
   * prior to rendering translucent objects. This is useful for e.g. depth
   * peeling.

   * If GetIsOpaque() == true, the depth mask is always enabled, regardless of
   * this key. Otherwise, the depth mask is disabled for default alpha blending
   * unless this key is set.

   * If this key is set, the integer value has the following meanings:
   * 0: glDepthMask(GL_FALSE)
   * 1: glDepthMask(GL_TRUE)
   * Anything else: No change to depth mask.
   */
  static vtkInformationIntegerKey* GLDepthMaskOverride();

protected:
  vtkDirect3DActor();
  ~vtkDirect3DActor();

  vtkMatrix4x4 *MCWCMatrix;
  vtkMatrix3x3 *NormalMatrix;
  vtkTransform *NormalTransform;
  vtkTimeStamp KeyMatrixTime;

private:
  vtkDirect3DActor(const vtkDirect3DActor&) VTK_DELETE_FUNCTION;
  void operator=(const vtkDirect3DActor&) VTK_DELETE_FUNCTION;
};

#endif
