/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkDirect3DActor.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkDirect3DActor.h"

#include "vtkInformation.h"
#include "vtkInformationIntegerKey.h"
#include "vtkMapper.h"
#include "vtkMatrix3x3.h"
#include "vtkMatrix4x4.h"
#include "vtkObjectFactory.h"
#include "vtkDirect3DPolyDataMapper.h"
#include "vtkDirect3DRenderer.h"
#include "vtkProperty.h"
#include "vtkRenderWindow.h"
#include "vtkTransform.h"

#include <cmath>

vtkStandardNewMacro(vtkDirect3DActor);

vtkInformationKeyMacro(vtkDirect3DActor, GLDepthMaskOverride, Integer)

vtkDirect3DActor::vtkDirect3DActor()
{
  this->MCWCMatrix = vtkMatrix4x4::New();
  this->NormalMatrix = vtkMatrix3x3::New();
  this->NormalTransform = vtkTransform::New();
}

vtkDirect3DActor::~vtkDirect3DActor()
{
  this->MCWCMatrix->Delete();
  this->NormalMatrix->Delete();
  this->NormalTransform->Delete();
}


// Actual actor render method.
void vtkDirect3DActor::Render(vtkRenderer *ren, vtkMapper *mapper)
{

  // get opacity
  bool opaque = (this->GetIsOpaque() != 0);
  if (opaque)
  {
//    glDepthMask(GL_TRUE);
  }
  else
  {
    vtkHardwareSelector* selector = ren->GetSelector();
    bool picking = (ren->GetRenderWindow()->GetIsPicking() || selector != NULL);
    if (picking)
    {
//      glDepthMask(GL_TRUE);
    }
    else
    {
      // check for deptgh peeling
      vtkInformation *info = this->GetPropertyKeys();
      if (info && info->Has(vtkDirect3DActor::GLDepthMaskOverride()))
      {
        int override = info->Get(vtkDirect3DActor::GLDepthMaskOverride());
        switch (override)
        {
          case 0:
  //          glDepthMask(GL_FALSE);
            break;
          case 1:
    //        glDepthMask(GL_TRUE);
            break;
          default:
            // Do nothing.
            break;
        }
      }
      else
      {
      //  glDepthMask(GL_FALSE); // transparency with alpha blending
      }
    }
  }

  // send a render to the mapper; update pipeline
  mapper->Render(ren, this);

  if (!opaque)
  {
//    glDepthMask(GL_TRUE);
  }

}

//----------------------------------------------------------------------------
void vtkDirect3DActor::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os,indent);
}

void vtkDirect3DActor::GetKeyMatrices(vtkMatrix4x4 *&mcwc, vtkMatrix3x3 *&normMat)
{
  // has the actor changed?
  if (this->GetMTime() > this->KeyMatrixTime)
  {
    this->ComputeMatrix();
    this->MCWCMatrix->DeepCopy(this->Matrix);
    this->MCWCMatrix->Transpose();

    if (this->GetIsIdentity())
    {
      this->NormalMatrix->Identity();
    }
    else
    {
      this->NormalTransform->SetMatrix(this->Matrix);
      vtkMatrix4x4 *mat4 = this->NormalTransform->GetMatrix();
      for(int i = 0; i < 3; ++i)
      {
        for (int j = 0; j < 3; ++j)
        {
          this->NormalMatrix->SetElement(i, j, mat4->GetElement(i, j));
        }
      }
    }
    this->NormalMatrix->Invert();
    this->KeyMatrixTime.Modified();
  }

  mcwc = this->MCWCMatrix;
  normMat = this->NormalMatrix;
}
