/*=========================================================================

  Copyright (c) Kitware, Inc.
  All rights reserved.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "mvActor.h"
#include "vtkActor.h"
#include "vtkLookupTable.h"
#include "vtkOpenGLPolyDataMapper.h"
#include "vtkOpenGLVertexBufferObject.h"
#include "vtkProperty.h"
#include "vtkXMLDataElement.h"
#include "vtksys/SystemTools.hxx"

mvActor::mvActor()
{
  this->VTKActor = vtkActor::New();
  vtkNew<vtkPolyDataMapper> mapper;
  static_cast<vtkOpenGLPolyDataMapper*>(
    mapper.Get())->SetVBOShiftScaleMethod(
      vtkOpenGLVertexBufferObject::ALWAYS_AUTO_SHIFT_SCALE);
  this->VTKActor->SetMapper(mapper);
}

mvActor::~mvActor()
{
  this->VTKActor->Delete();
}

void mvActor::LoadData(vtkXMLDataElement *actorel)
{
  actorel->GetScalarAttribute("PolyData", this->PolyDataID);
  this->TextureID = -1;
  actorel->GetScalarAttribute("TextureData", this->TextureID);

  vtkActor *actor = this->VTKActor;

  double dtmp3[3];
  actorel->GetVectorAttribute("Scale", 3, dtmp3);
  actor->SetScale(dtmp3);
  actorel->GetVectorAttribute("Position", 3, dtmp3);
  actor->SetPosition(dtmp3);
  actorel->GetVectorAttribute("Origin", 3, dtmp3);
  actor->SetOrigin(dtmp3);
  actorel->GetVectorAttribute("Orientation", 3, dtmp3);
  actor->SetOrientation(dtmp3);

  actorel->GetVectorAttribute("DiffuseColor", 3, dtmp3);
  actor->GetProperty()->SetDiffuseColor(dtmp3);
  actorel->GetVectorAttribute("AmbientColor", 3, dtmp3);
  actor->GetProperty()->SetAmbientColor(dtmp3);
  actorel->GetVectorAttribute("SpecularColor", 3, dtmp3);
  actor->GetProperty()->SetSpecularColor(dtmp3);

  double dtmp;
  actorel->GetScalarAttribute("Diffuse", dtmp);
  actor->GetProperty()->SetDiffuse(dtmp);
  actorel->GetScalarAttribute("Ambient", dtmp);
  actor->GetProperty()->SetAmbient(dtmp);
  actorel->GetScalarAttribute("Specular", dtmp);
  actor->GetProperty()->SetSpecular(dtmp);
  actorel->GetScalarAttribute("SpecularPower", dtmp);
  actor->GetProperty()->SetSpecularPower(dtmp);
  actorel->GetScalarAttribute("Opacity", dtmp);
  actor->GetProperty()->SetOpacity(dtmp);
  this->Opacity = dtmp;
  if (dtmp >= 1.0)
  {
    actor->ForceOpaqueOn();
  }

  // optional line width
  if (actorel->GetScalarAttribute("LineWidth", dtmp))
  {
    actor->GetProperty()->SetLineWidth(dtmp);
  }

  int itmp;
  actor->GetMapper()->SetArrayName(
    actorel->GetAttribute("ScalarArrayName"));
  actorel->GetScalarAttribute("ScalarVisibility", itmp);
  actor->GetMapper()->SetScalarVisibility(itmp);
  actorel->GetScalarAttribute("ScalarMode", itmp);
  actor->GetMapper()->SetScalarMode(itmp);
  actorel->GetVectorAttribute("ScalarRange", 2, dtmp3);
  actor->GetMapper()->SetScalarRange(dtmp3);
  actorel->GetScalarAttribute("ScalarArrayId", itmp);
  actor->GetMapper()->SetArrayId(itmp);
  actorel->GetScalarAttribute("ScalarArrayAccessMode", itmp);
  actor->GetMapper()->SetArrayAccessMode(itmp);
  actorel->GetScalarAttribute("ScalarArrayComponent", itmp);
  actor->GetMapper()->SetArrayComponent(itmp);
  vtkLookupTable::SafeDownCast(
    actor->GetMapper()->GetLookupTable())->SetHueRange(0.7, 0.0);
}
