# IParaView Jupyter Kernel

Copyright (c) 2021 Kitware SAS
All rights reserved.

IParaView-Kernel is a free software; you can redistribute it and/or modify it
under the terms of the IParaView-Kernel license.

See License.txt for the full IParaView-Kernel license.

## How to install

This plugin has 3 dependencies :

 - *ParaView* with Qt support (see https://gitlab.kitware.com/paraview/paraview)
 - *ipykernel* (through `pip`)
 - *IPython* (through your packet manager)

Once these dependencies are installed, create a build directory and build the project using CMake like a regular C++ project.
Important CMake variables :

 - `ParaView_DIR` : the build/install folder of the ParaView this plugin has to work with.
 - `CMAKE_INSTALL_PREFIX` : where to install the kernel.
See https://jupyter-client.readthedocs.io/en/stable/kernels.html#kernel-specs for the list of the locations jupyter will look by default.

### Important

This project **must** be installed so it can work correctly out of the box (via `cmake --build <build-folder> --target install` for example).

## How to use

 - Install the kernel
 - Launch an IPython interface.For example if you work with the notebook interface : `jupyter notebook`
 - Create a new project and choose the kernel named `IParaView Kernel`

This jupyter kernel will try to launch a `pvserver` on port `localhost` a random port between 11000 and 50000. If it cannot kernel will fail.
The interpreter will then connect to the server at startup and directly setup the environment so you can right away type some pvpython commands.

To have more information on what is available specifically through this kernel, type magic command `%help` in the interpreter.

For a basic example of the kernel see `Exemples/simpleDemo.ipynb`.
