#include "pqJupyterCollaborationManager.h"

#include <pqActiveObjects.h>
#include <pqApplicationCore.h>
#include <pqServer.h>

#include <vtkCommand.h>
#include <vtkReservedRemoteObjectIds.h>
#include <vtkSMCollaborationManager.h>
#include <vtkSMMessage.h>
#include <vtkSMSession.h>
#include <vtkSMSessionProxyManager.h>

#include <QTimer>
#include <QtDebug>

//-----------------------------------------------------------------------------
pqJupyterCollaborationManager::pqJupyterCollaborationManager(QObject *parent)
    : QObject(parent)
{
}

//-----------------------------------------------------------------------------
pqJupyterCollaborationManager::~pqJupyterCollaborationManager() = default;

//-----------------------------------------------------------------------------
void pqJupyterCollaborationManager::onStartup()
{
  pqServer *server = pqApplicationCore::instance()->getActiveServer();
  if (server && server->session()) {
    this->initialize(server->session()->GetCollaborationManager());
  }

  QObject::connect(&pqActiveObjects::instance(),
                   &pqActiveObjects::serverChanged, [this](pqServer *server) {
                     if (server && server->session()) {
                       this->initialize(
                           server->session()->GetCollaborationManager());
                     }
                   });
}

//-----------------------------------------------------------------------------
void pqJupyterCollaborationManager::onShutdown() {}

//-----------------------------------------------------------------------------
void pqJupyterCollaborationManager::initialize(
    vtkSMCollaborationManager *manager)
{
}
