#ifndef QTVALIDITYWIDGET_H
#define QTVALIDITYWIDGET_H

#include <QGraphicsLayoutItem>
#include <QGraphicsPolygonItem>
#include <QGraphicsRectItem>
#include <QGraphicsScene>
#include <QGraphicsView>
#include <QHBoxLayout>
#include <QWidget>

class qtMaterialMultiPhaseValidityWidget : public QWidget
{
  Q_OBJECT
  using Superclass = QWidget;

public:
  enum
  {
    Transition,
    Internal
  };

  qtMaterialMultiPhaseValidityWidget(QWidget* parent = nullptr);

  void setValid(int flag, bool valid);

  QColor validColor() const;
  void setValidColor(const QColor& validColor);

  QColor invalidColor() const;
  void setInvalidColor(const QColor& invalidColor);

private:
  bool m_internalValid;
  bool m_globalValid;

  QColor m_validColor;
  QColor m_invalidColor;

  QHBoxLayout* m_layout;
  QGraphicsScene* m_scene;
  QGraphicsView* m_view;
  QGraphicsPolygonItem* m_internalValidGlyph;
  QGraphicsRectItem* m_globalValidGlyph;
};

#endif // QTVALIDITYWIDGET_H
