#include "qtMaterialMultiPhaseValidityWidget.h"
#include <QGraphicsWidget>
#include <iostream>

qtMaterialMultiPhaseValidityWidget::qtMaterialMultiPhaseValidityWidget(QWidget* parent)
  : Superclass(parent)
{
  m_layout = new QHBoxLayout;
  m_scene = new QGraphicsScene;
  m_scene->setSceneRect({ 0, 0, 40, 20 });
  //  auto* validityGraphicsWidget = new QGraphicsWidget;
  //  auto* graphicsLayout = new QGraphicsLinearLayout;
  m_globalValidGlyph = new QGraphicsRectItem(0, 0, 20, 20);
  m_internalValidGlyph = new QGraphicsPolygonItem();
  QPolygonF polygon;
  polygon << QPointF(20., 0.) << QPointF(40., 0.) << QPointF(30, 20.);
  m_internalValidGlyph->setPolygon(polygon);
  m_scene->addItem(m_globalValidGlyph);
  m_scene->addItem(m_internalValidGlyph);
  m_view = new QGraphicsView(m_scene);
  m_view->setSceneRect({ 0, 0, 40, 20 });
  m_view->setFixedSize({ 50, 25 });
  m_layout->addWidget(m_view);
  this->setLayout(m_layout);

  m_validColor = QColor(50, 200, 50);
  m_invalidColor = QColor(200, 50, 50);

  this->setValid(this->Transition, true);
  this->setValid(this->Internal, true);
}

void qtMaterialMultiPhaseValidityWidget::setValid(int flag, bool valid)
{
  QBrush brush = valid ? QBrush(m_validColor) : QBrush(m_invalidColor);

  switch (flag)
  {
    case qtMaterialMultiPhaseValidityWidget::Transition:
    {
      m_globalValid = valid;
      m_globalValidGlyph->setBrush(brush);
      break;
    }
    case qtMaterialMultiPhaseValidityWidget::Internal:
    {
      m_internalValid = valid;
      m_internalValidGlyph->setBrush(brush);
      break;
    }
    default:
    {
      std::cerr << "wrong valid type." << std::endl;
    }
  }
}

QColor qtMaterialMultiPhaseValidityWidget::validColor() const
{
  return m_validColor;
}

void qtMaterialMultiPhaseValidityWidget::setValidColor(const QColor& validColor)
{
  m_validColor = validColor;
}

QColor qtMaterialMultiPhaseValidityWidget::invalidColor() const
{
  return m_invalidColor;
}

void qtMaterialMultiPhaseValidityWidget::setInvalidColor(const QColor& invalidColor)
{
  m_invalidColor = invalidColor;
}
