//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME qtMaterialItem - UI components for Truchas material phase/transition sequence
// .SECTION Description
// .SECTION See Also
// qtItem

#ifndef __smtk_extension_qtMaterialItem_h
#define __smtk_extension_qtMaterialItem_h

#include "smtk/extension/qt/Exports.h"
#include "smtk/extension/qt/qtAttributeItemInfo.h"
#include "smtk/extension/qt/qtItem.h"

#include <QString>

class qtMaterialItemInternals;
class qtMaterialAttribute;

typedef smtk::extension::qtAttributeItemInfo qtItemInfo;

// Implements custom UI for Truchas materials, which can be a sequence
// of phases with transitions between them. This class is a subclass of
// qtItem, even though it displays two interleaved group items ("phases"
// and "transitions").

class SMTKQTEXT_EXPORT qtMaterialItem : public smtk::extension::qtItem
{
  Q_OBJECT

public:
  static smtk::extension::qtItem* createItemWidget(
    const qtItemInfo& phasesInfo, qtMaterialAttribute* attribute);
  qtMaterialItem(const qtItemInfo& info, qtMaterialAttribute* attribute);
  virtual ~qtMaterialItem();
  // void setLabelVisible(bool) override;

protected slots:
  // void updateItemData() override;
  // virtual void setEnabledState(bool checked);
  // virtual void onAddSubGroup();
  // virtual void onRemoveSubGroup();
  // void onChildWidgetSizeChanged() override;
  // virtual void onChildItemModified();
  void checkValidity();

protected:
  void createWidget() override;

  QWidget* createElementWidget(
    smtk::attribute::GroupItemPtr groupItem, std::size_t element, const QString& labelString);
  // virtual void addSubGroup(int i);
  // virtual void updateExtensibleState();
  // virtual void addItemsToTable(int i);
  void updateTableItemSizes();
  void setTableRowFromPhase(int row, size_t element);
  void setTableRowFromTransition(int row, size_t element);
  void addTransitionToTable(int row, int element);
  void setTableRowWidgets(int row, QWidget* widget);
  void swapPhase(size_t phaseA, size_t phaseB);
  void setTransitionToDefault(int row);
  void setTransitionsToDefault(const std::vector<int>& rows);

  QWidget* createDataWidget();
  void recreateDataWidget();

  void movePhaseDown(int row);
  void movePhaseUp(int row);

  void addPhase();
  void removeSelected();

  void setRowCollapsed(int row, bool collapsed);

private:
  qtMaterialItemInternals* Internals;

}; // class

#endif
