//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
// .NAME vtkImageSpacingFlip - Flips the image so spacing is positive
// .SECTION Description
// Flips the image so spacing is positive.

#ifndef vtkImageSpacingFlip_h
#define vtkImageSpacingFlip_h

#include "smtk/extension/vtk/filter/vtkSMTKFilterExtModule.h" // For export macro

#include "vtkImageAlgorithm.h"

class VTKSMTKFILTEREXT_EXPORT vtkImageSpacingFlip : public vtkImageAlgorithm
{
public:
  static vtkImageSpacingFlip* New();
  vtkTypeMacro(vtkImageSpacingFlip, vtkImageAlgorithm);

  vtkImageSpacingFlip(const vtkImageSpacingFlip&) = delete;
  vtkImageSpacingFlip& operator=(const vtkImageSpacingFlip&) = delete;

protected:
  vtkImageSpacingFlip();
  ~vtkImageSpacingFlip() override;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;
};

#endif
