/*=========================================================================

  Program:   ParaView
  Module:    vtkPVHistogramChartRepresentation.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkPVHistogramChartRepresentation
// .SECTION Description

#ifndef __vtkPVHistogramChartRepresentation_h
#define __vtkPVHistogramChartRepresentation_h

#include "vtkXYChartRepresentation.h"

class vtkDataObject;
class vtkInformationVector;
class vtkPExtractHistogram;
class vtkSelection;

class VTKPVCLIENTSERVERCORERENDERING_EXPORT vtkPVHistogramChartRepresentation : public vtkXYChartRepresentation
{
public:
  static vtkPVHistogramChartRepresentation* New();
  vtkTypeMacro(vtkPVHistogramChartRepresentation, vtkXYChartRepresentation);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Controls which input data component should be binned, for input arrays
  // with more-than-one component
  void SetComponent(int);
  int GetComponent();

  // Description:
  // Controls the number of bins N in the output histogram data
  void SetBinCount(int);
  int GetBinCount();

  // Description:
  // Get/Set custom bin ranges to use. These are used only when
  // UseCustomBinRanges is set to true.
  void SetCustomBinRanges(double ranges[2]);
  double* GetCustomBinRanges();

  // Description:
  // When set to true, CustomBinRanges will  be used instead of using the full
  // range for the selected array. By default, set to false.
  void SetUseCustomBinRanges(bool);
  bool GetUseCustomBinRanges();

  // Description:
  // Sets the color for the histograms.
  void SetHistogramColor(double r, double g, double b);

  // Description:
  // Method to be overrided to transform input data to a vtkTable.
  virtual vtkDataObject* TransformInputData(vtkInformationVector** inputVector,
                                            vtkDataObject* data);

  // Description:
  // Get the current selection.
  virtual vtkSelection* GetSelection();

  // Description:
  // Reset the current selection to an empty state.
  void ResetSelection();

  // Description:
  // This needs to be called on all instances of vtkGeometryRepresentation when
  // the input is modified. This is essential since the geometry filter does not
  // have any real-input on the client side which messes with the Update
  // requests.
  virtual void MarkModified();

//BTX
protected:
  vtkPVHistogramChartRepresentation();
  ~vtkPVHistogramChartRepresentation();

  virtual void PrepareForRendering();

  vtkPExtractHistogram* ExtractHistogram;
  std::string ArrayName;
  int AttributeType;
  double HistogramColor[3];

private:
  vtkPVHistogramChartRepresentation(const vtkPVHistogramChartRepresentation&); // Not implemented
  void operator=(const vtkPVHistogramChartRepresentation&); // Not implemented
//ETX
};

#endif
