# Conda Build Status

As of 24-Feb-2019, it is possible to build conda packages for
linux and macOS, but not from the same source commit.
The major problems seem to stem from the boost libraries
used by smtk, xmsmesh, and smtkxmsmesh.

The conda builds should be considered prototypes, and there are
a number of uncertainties in the build steps (not uncommon for
conda builds at Kitware.) This document attempts to record
the most salient known issues/lore.

## Packages
Packages have been uploaded to the johnkit area in anaconda.org.
To install:

```
conda install -c defaults -c conda-forge -c johnkit -c aquaveo smtk-xms-mesh
```

There is an example script in the source repository, at 
```conda/GenerateFaceMeshFromPolygon.py``` . After cloning the repo and
installing smtk-xms-mesh, you can run this script, which loads a simple 2D model,
generates a face mesh, and writes the mesh to a 2dm file.


## macOS build
Commit 39c8acd (23-Feb-2019) has been used to build conda packages
on macOS.

* This commit has the preferred logic, because bypasses the conan logic
  in the CMakeLists.txt files, and instead uses the conda xmsmesh packages.
* In python scripts, you must import xmsmesh before smtkxmsmesh, otherwise
  the \_smtkPybindXMSMesh.so library will fail to load, with a "Symbol not found"
  error for the boost::archive_exception destructor. This has something to
  do with xmsmesh being a static build and the pybind libs being dynamic.
* Side note: the linux build for this commit fails to load \_smtkPybindXMSMesh
  with a "Symbol not found" error for "typeinfo for boost::detail::thread_data_base".
  (And no combination of import steps seems to make the problem go away.)

## linux build
Commit 3366784 (10-Feb-2019) has been used to build linux packages on ubuntu 16.04.
This commit is the one just preceedeing 39c8acd, which is used to build macOS packages.

* This commit uses xmsmesh packages loaded by conan. This presumably
  only works because the conan and conda packages are the same.
