//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#include "smtk/common/CompilerInformation.h"

SMTK_THIRDPARTY_PRE_INCLUDE
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>
SMTK_THIRDPARTY_POST_INCLUDE

#include "smtk/resource/Manager.h"
#include "smtk/operation/Manager.h"

#include "smtk/extension/paraview/pluginsupport/PluginManager.txx"

#include <memory>
#include <utility>

namespace py = pybind11;

template <typename T, typename... Args>
using PySharedPtrClass = py::class_<T, std::shared_ptr<T>, Args...>;

PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>);

PYBIND11_MODULE(_smtkPybindParaviewPluginSupport, pluginsupport)
{
  // We need to explicitly list all of the managers we want our plugin manager
  // to accept. I'm sure there's a way to do this more elegantly, but for now I
  // am ok with this being our payment for plugin registration in python (which
  // has full access to the "environment" managers anyway). This module is
  // really only supposed to be used for testing; it may move into the testing
  // directory.
  pluginsupport
    .def("registerPluginsTo", [](const std::shared_ptr<smtk::resource::Manager>& manager) {
        smtk::extension::paraview::PluginManager::instance()->registerPluginsTo(manager);
      })
    .def("unregisterPluginsFrom", [](const std::shared_ptr<smtk::resource::Manager>& manager) {
        smtk::extension::paraview::PluginManager::instance()->unregisterPluginsFrom(manager);
      })
    .def("registerPluginsTo", [](const std::shared_ptr<smtk::operation::Manager>& manager) {
        smtk::extension::paraview::PluginManager::instance()->registerPluginsTo(manager);
      })
    .def("unregisterPluginsFrom", [](const std::shared_ptr<smtk::operation::Manager>& manager) {
        smtk::extension::paraview::PluginManager::instance()->unregisterPluginsFrom(manager);
      })
    ;
}
