//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================
#include "smtk/extension/qt/qtTableWidget.h"

#include <QHeaderView>
#include <QKeyEvent>
using namespace smtk::extension;

qtTableWidget::qtTableWidget(QWidget* p)
  : QTableWidget(p)
{
  // Table should always fills the frame and resizes to contents
  this->horizontalHeader()->setStretchLastSection(true);
#if QT_VERSION >= 0x050000
  this->verticalHeader()->setSectionResizeMode(QHeaderView::ResizeToContents);
#else
  this->verticalHeader()->setResizeMode(QHeaderView::ResizeToContents);
#endif
}

qtTableWidget::~qtTableWidget()
{
}

void qtTableWidget::keyPressEvent(QKeyEvent* e)
{
  emit this->keyPressed(e);
}
