//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_model_Vertex_h
#define pybind_smtk_model_Vertex_h

#include <pybind11/pybind11.h>

#include "smtk/model/Vertex.h"

namespace py = pybind11;

py::class_< smtk::model::Vertex > pybind11_init_smtk_model_Vertex(py::module &m, py::class_< smtk::model::CellEntity >& parent)
{
  py::class_< smtk::model::Vertex > instance(m, "Vertex", parent);
  instance
    .def(py::init<::smtk::model::Vertex const &>())
    .def(py::init<>())
    .def(py::init<::smtk::model::EntityRef const &>())
    .def(py::init<::smtk::model::ManagerPtr, ::smtk::common::UUID const &>())
    .def("__ne__", (bool (smtk::model::Vertex::*)(::smtk::model::EntityRef const &) const) &smtk::model::Vertex::operator!=)
    .def("deepcopy", (smtk::model::Vertex & (smtk::model::Vertex::*)(::smtk::model::Vertex const &)) &smtk::model::Vertex::operator=)
    .def("__eq__", (bool (smtk::model::Vertex::*)(::smtk::model::EntityRef const &) const) &smtk::model::Vertex::operator==)
    .def("classname", &smtk::model::Vertex::classname)
    .def("coordinates", &smtk::model::Vertex::coordinates)
    .def("edges", &smtk::model::Vertex::edges)
    .def("isValid", (bool (smtk::model::Vertex::*)() const) &smtk::model::Vertex::isValid)
    // This method passes around a bare pointer
    // .def("isValid", (bool (smtk::model::Vertex::*)(::smtk::model::Entity * *) const) &smtk::model::Vertex::isValid, py::arg("entRec"))
    ;
  return instance;
}

#endif
