//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_model_UseEntity_h
#define pybind_smtk_model_UseEntity_h

#include <pybind11/pybind11.h>

#include "smtk/model/UseEntity.h"

namespace py = pybind11;

py::class_< smtk::model::UseEntity > pybind11_init_smtk_model_UseEntity(py::module &m, py::class_< smtk::model::EntityRef >& parent)
{
  py::class_< smtk::model::UseEntity > instance(m, "UseEntity", parent);
  instance
    .def(py::init<::smtk::model::UseEntity const &>())
    .def(py::init<>())
    .def(py::init<::smtk::model::EntityRef const &>())
    .def(py::init<::smtk::model::ManagerPtr, ::smtk::common::UUID const &>())
    .def("__ne__", (bool (smtk::model::UseEntity::*)(::smtk::model::EntityRef const &) const) &smtk::model::UseEntity::operator!=)
    .def("deepcopy", (smtk::model::UseEntity & (smtk::model::UseEntity::*)(::smtk::model::UseEntity const &)) &smtk::model::UseEntity::operator=)
    .def("__eq__", (bool (smtk::model::UseEntity::*)(::smtk::model::EntityRef const &) const) &smtk::model::UseEntity::operator==)
    .def_property("boundingShellEntity", &smtk::model::UseEntity::boundingShellEntity, &smtk::model::UseEntity::setBoundingShellEntity)
    .def("addShellEntity", &smtk::model::UseEntity::addShellEntity, py::arg("shell"))
    .def("cell", &smtk::model::UseEntity::cell)
    .def("classname", &smtk::model::UseEntity::classname)
    .def("isValid", (bool (smtk::model::UseEntity::*)() const) &smtk::model::UseEntity::isValid)
    // This method passes around a bare pointer
    // .def("isValid", (bool (smtk::model::UseEntity::*)(::smtk::model::Entity * *) const) &smtk::model::UseEntity::isValid, py::arg("entRec"))
    .def("orientation", &smtk::model::UseEntity::orientation)
    .def("sense", &smtk::model::UseEntity::sense)
    ;
  return instance;
}

#endif
