//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_model_Model_h
#define pybind_smtk_model_Model_h

#include <pybind11/pybind11.h>

#include "smtk/model/Model.h"

namespace py = pybind11;

py::class_< smtk::model::Model > pybind11_init_smtk_model_Model(py::module &m, py::class_< smtk::model::EntityRef >& parent)
{
  py::class_< smtk::model::Model > instance(m, "Model", parent);
  instance
    .def(py::init<::smtk::model::Model const &>())
    .def(py::init<>())
    .def(py::init<::smtk::model::EntityRef const &>())
    .def(py::init<::smtk::model::ManagerPtr, ::smtk::common::UUID const &>())
    .def("__ne__", (bool (smtk::model::Model::*)(::smtk::model::EntityRef const &) const) &smtk::model::Model::operator!=)
    .def("deepcopy", (smtk::model::Model & (smtk::model::Model::*)(::smtk::model::Model const &)) &smtk::model::Model::operator=)
    .def("__eq__", (bool (smtk::model::Model::*)(::smtk::model::EntityRef const &) const) &smtk::model::Model::operator==)
    .def_property("session", &smtk::model::Model::session, &smtk::model::Model::setSession)
    .def("addCell", &smtk::model::Model::addCell, py::arg("c"))
    .def("addGroup", &smtk::model::Model::addGroup, py::arg("g"))
    .def("addSubmodel", &smtk::model::Model::addSubmodel, py::arg("m"))
    .def("assignDefaultNames", &smtk::model::Model::assignDefaultNames)
    .def("cells", &smtk::model::Model::cells)
    .def("classname", &smtk::model::Model::classname)
    .def("geometryStyle", &smtk::model::Model::geometryStyle)
    .def("groups", &smtk::model::Model::groups)
    .def("isValid", (bool (smtk::model::Model::*)() const) &smtk::model::Model::isValid)
    // This method passes around a bare pointer
    // .def("isValid", (bool (smtk::model::Model::*)(::smtk::model::Entity * *) const) &smtk::model::Model::isValid, py::arg("entRec"))
    .def("op", &smtk::model::Model::op, py::arg("operatorName"))
    .def("operatorNames", &smtk::model::Model::operatorNames)
    .def("parent", &smtk::model::Model::parent)
    .def("removeCell", &smtk::model::Model::removeCell, py::arg("c"))
    .def("removeGroup", &smtk::model::Model::removeGroup, py::arg("g"))
    .def("removeSubmodel", &smtk::model::Model::removeSubmodel, py::arg("m"))
    .def("setEmbeddingDimension", &smtk::model::Model::setEmbeddingDimension, py::arg("dim"))
    .def("submodels", &smtk::model::Model::submodels)
    ;
  return instance;
}

#endif
