//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_model_DescriptivePhrase_h
#define pybind_smtk_model_DescriptivePhrase_h

#include <pybind11/pybind11.h>

#include "smtk/model/DescriptivePhrase.h"

#include "smtk/mesh/Collection.h"
#include "smtk/model/SubphraseGenerator.h"

namespace py = pybind11;

PySharedPtrClass< smtk::model::DescriptivePhrase > pybind11_init_smtk_model_DescriptivePhrase(py::module &m)
{
  PySharedPtrClass< smtk::model::DescriptivePhrase > instance(m, "DescriptivePhrase");
  instance
    .def(py::init<::smtk::model::DescriptivePhrase const &>())
    .def("deepcopy", (smtk::model::DescriptivePhrase & (smtk::model::DescriptivePhrase::*)(::smtk::model::DescriptivePhrase const &)) &smtk::model::DescriptivePhrase::operator=)
    .def_property("title", &smtk::model::DescriptivePhrase::title, &smtk::model::DescriptivePhrase::setTitle)
    .def_property("relatedColor", &smtk::model::DescriptivePhrase::relatedColor, &smtk::model::DescriptivePhrase::setRelatedColor)
    .def_property("subtitle", &smtk::model::DescriptivePhrase::subtitle, &smtk::model::DescriptivePhrase::setSubtitle)
    .def("areSubphrasesBuilt", &smtk::model::DescriptivePhrase::areSubphrasesBuilt)
    .def("argFindChild", (int (smtk::model::DescriptivePhrase::*)(::smtk::model::DescriptivePhrase const *) const) &smtk::model::DescriptivePhrase::argFindChild, py::arg("child"))
    .def("argFindChild", (int (smtk::model::DescriptivePhrase::*)(::smtk::model::EntityRef const &) const) &smtk::model::DescriptivePhrase::argFindChild, py::arg("child"))
    .def("argFindChild", (int (smtk::model::DescriptivePhrase::*)(::smtk::mesh::MeshSet const &) const) &smtk::model::DescriptivePhrase::argFindChild, py::arg("child"))
    .def("argFindChild", (int (smtk::model::DescriptivePhrase::*)(::smtk::mesh::CollectionPtr const &) const) &smtk::model::DescriptivePhrase::argFindChild, py::arg("child"))
    .def("argFindChild", (int (smtk::model::DescriptivePhrase::*)(::std::string const &, ::smtk::model::PropertyType) const) &smtk::model::DescriptivePhrase::argFindChild, py::arg("propName"), py::arg("propType"))
    .def("classname", &smtk::model::DescriptivePhrase::classname)
    .def("findDelegate", &smtk::model::DescriptivePhrase::findDelegate)
    .def("indexInParent", &smtk::model::DescriptivePhrase::indexInParent)
    .def("isPropertyValueType", &smtk::model::DescriptivePhrase::isPropertyValueType)
    .def("isRelatedColorMutable", &smtk::model::DescriptivePhrase::isRelatedColorMutable)
    .def("isSubtitleMutable", &smtk::model::DescriptivePhrase::isSubtitleMutable)
    .def("isTitleMutable", &smtk::model::DescriptivePhrase::isTitleMutable)
    .def("markDirty", &smtk::model::DescriptivePhrase::markDirty, py::arg("dirty") = true)
    .def("parent", &smtk::model::DescriptivePhrase::parent)
    .def("phraseId", &smtk::model::DescriptivePhrase::phraseId)
    .def("phraseType", &smtk::model::DescriptivePhrase::phraseType)
    .def("relatedArrangementKind", &smtk::model::DescriptivePhrase::relatedArrangementKind)
    .def("relatedAttributeId", &smtk::model::DescriptivePhrase::relatedAttributeId)
    .def("relatedEntity", &smtk::model::DescriptivePhrase::relatedEntity)
    .def("relatedEntityId", &smtk::model::DescriptivePhrase::relatedEntityId)
    .def("relatedMesh", &smtk::model::DescriptivePhrase::relatedMesh)
    .def("relatedMeshCollection", &smtk::model::DescriptivePhrase::relatedMeshCollection)
    .def("relatedPropertyName", &smtk::model::DescriptivePhrase::relatedPropertyName)
    .def("relatedPropertyType", &smtk::model::DescriptivePhrase::relatedPropertyType)
    .def("setDelegate", &smtk::model::DescriptivePhrase::setDelegate, py::arg("delegate"))
    .def("setup", &smtk::model::DescriptivePhrase::setup, py::arg("phraseType"), py::arg("parent") = ::smtk::model::DescriptivePhrase::Ptr( ))
    .def("subphrases", (smtk::model::DescriptivePhrases & (smtk::model::DescriptivePhrase::*)()) &smtk::model::DescriptivePhrase::subphrases)
    .def("subphrases", (smtk::model::DescriptivePhrases (smtk::model::DescriptivePhrase::*)() const) &smtk::model::DescriptivePhrase::subphrases)
    ;
  return instance;
}

#endif
