//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_model_CellEntity_h
#define pybind_smtk_model_CellEntity_h

#include <pybind11/pybind11.h>

#include "smtk/model/CellEntity.h"

namespace py = pybind11;

py::class_< smtk::model::CellEntity > pybind11_init_smtk_model_CellEntity(py::module &m, py::class_< smtk::model::EntityRef >& parent)
{
  py::class_< smtk::model::CellEntity > instance(m, "CellEntity", parent);
  instance
    .def(py::init<::smtk::model::CellEntity const &>())
    .def(py::init<>())
    .def(py::init<::smtk::model::EntityRef const &>())
    .def(py::init<::smtk::model::ManagerPtr, ::smtk::common::UUID const &>())
    .def("__ne__", (bool (smtk::model::CellEntity::*)(::smtk::model::EntityRef const &) const) &smtk::model::CellEntity::operator!=)
    .def("deepcopy", (smtk::model::CellEntity & (smtk::model::CellEntity::*)(::smtk::model::CellEntity const &)) &smtk::model::CellEntity::operator=)
    .def("__eq__", (bool (smtk::model::CellEntity::*)(::smtk::model::EntityRef const &) const) &smtk::model::CellEntity::operator==)
    .def("boundingCellUses", &smtk::model::CellEntity::boundingCellUses, py::arg("orientation"))
    .def("boundingCells", &smtk::model::CellEntity::boundingCells)
    .def("classname", &smtk::model::CellEntity::classname)
    .def("findShellEntitiesContainingCell", &smtk::model::CellEntity::findShellEntitiesContainingCell, py::arg("cell"))
    .def("findShellEntityContainingUse", &smtk::model::CellEntity::findShellEntityContainingUse, py::arg("bdyUse"))
    .def("isValid", (bool (smtk::model::CellEntity::*)() const) &smtk::model::CellEntity::isValid)
    // This method passes around a bare pointer
    // .def("isValid", (bool (smtk::model::CellEntity::*)(::smtk::model::Entity * *) const) &smtk::model::CellEntity::isValid, py::arg("entRec"))
    .def("model", &smtk::model::CellEntity::model)
    ;
  return instance;
}

#endif
