//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_common_View_h
#define pybind_common_View_h

#include <pybind11/pybind11.h>

#include "smtk/common/View.h"

namespace py = pybind11;

void pybind11_init_smtk_common_View(py::module &m)
{
  py::class_<smtk::common::View> instance(m, "View");
  instance
    .def(py::init<::std::string const &, ::std::string const &>())
    .def_property("iconName", &smtk::common::View::iconName, &smtk::common::View::setIconName)
    .def_static("New", &smtk::common::View::New, py::arg("myType"), py::arg("myTitle"))
    .def("title", &smtk::common::View::title)
    .def("type", &smtk::common::View::type)
    .def("details", &smtk::common::View::details)
    ;
}

void pybind11_init_smtk_common_View_Component(py::module &m)
{
  py::class_<smtk::common::View::Component> instance(m, "Component");
  instance
    .def(py::init<::std::string const &>())
    .def(py::init<>())
    .def(py::init<::smtk::common::View::Component const &>())
    .def("deepcopy", (smtk::common::View::Component & (smtk::common::View::Component::*)(::smtk::common::View::Component const &)) &smtk::common::View::Component::operator=)
    .def_property("contents", &smtk::common::View::Component::contents, &smtk::common::View::Component::setContents)
    .def_property("attribute", &smtk::common::View::Component::attribute, &smtk::common::View::Component::setAttribute)
    .def("name", &smtk::common::View::Component::name)
    .def("contentsAsVector", &smtk::common::View::Component::contentsAsVector, py::arg("vec"))
    .def("contentsAsInt", &smtk::common::View::Component::contentsAsInt, py::arg("val"))
    .def("attributeAsBool", (bool (smtk::common::View::Component::*)(::std::string const &, bool &) const) &smtk::common::View::Component::attributeAsBool)
    .def("attributeAsBool", (bool (smtk::common::View::Component::*)(::std::string const &) const) &smtk::common::View::Component::attributeAsBool)
    .def("attributes", &smtk::common::View::Component::attributes)
    .def("addChild", &smtk::common::View::Component::addChild, py::arg("childName"))
    .def("numberOfChildren", &smtk::common::View::Component::numberOfChildren)
    .def("child", &smtk::common::View::Component::child, py::arg("i"))
    .def("findChild", &smtk::common::View::Component::findChild, py::arg("compName"))
    ;
}

#endif
