//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_bridge_discrete_operators_BathymetryOperator_h
#define pybind_smtk_bridge_discrete_operators_BathymetryOperator_h

#include <pybind11/pybind11.h>

#include "smtk/bridge/discrete/operators/BathymetryOperator.h"

#include "smtk/model/Operator.h"

namespace py = pybind11;

PySharedPtrClass< smtk::bridge::discrete::BathymetryOperator, smtk::model::Operator > pybind11_init_smtk_bridge_discrete_BathymetryOperator(py::module &m)
{
  PySharedPtrClass< smtk::bridge::discrete::BathymetryOperator, smtk::model::Operator > instance(m, "BathymetryOperator");
  instance
    .def("classname", &smtk::bridge::discrete::BathymetryOperator::classname)
    .def_static("create", (std::shared_ptr<smtk::bridge::discrete::BathymetryOperator> (*)()) &smtk::bridge::discrete::BathymetryOperator::create)
    .def_static("create", (std::shared_ptr<smtk::bridge::discrete::BathymetryOperator> (*)(::std::shared_ptr<smtk::bridge::discrete::BathymetryOperator> &)) &smtk::bridge::discrete::BathymetryOperator::create, py::arg("ref"))
    .def("shared_from_this", (std::shared_ptr<smtk::bridge::discrete::BathymetryOperator> (smtk::bridge::discrete::BathymetryOperator::*)()) &smtk::bridge::discrete::BathymetryOperator::shared_from_this)
    .def("shared_from_this", (std::shared_ptr<const smtk::bridge::discrete::BathymetryOperator> (smtk::bridge::discrete::BathymetryOperator::*)() const) &smtk::bridge::discrete::BathymetryOperator::shared_from_this)
    .def("name", &smtk::bridge::discrete::BathymetryOperator::name)
    .def("className", &smtk::bridge::discrete::BathymetryOperator::className)
    .def_static("baseCreate", &smtk::bridge::discrete::BathymetryOperator::baseCreate)
    .def("ableToOperate", &smtk::bridge::discrete::BathymetryOperator::ableToOperate)
    ;
  return instance;
}

#endif
