//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_VoidItemDefinition_h
#define pybind_attribute_VoidItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/VoidItemDefinition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_VoidItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::VoidItemDefinition, std::shared_ptr<smtk::attribute::VoidItemDefinition> > instance(m, "VoidItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::VoidItemDefinition const &>())
    .def_static("New", &smtk::attribute::VoidItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::VoidItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::VoidItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::VoidItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::VoidItemDefinition::buildItem)
    .def("classname", &smtk::attribute::VoidItemDefinition::classname)
    .def("createCopy", &smtk::attribute::VoidItemDefinition::createCopy, py::arg("info"))
    .def("type", &smtk::attribute::VoidItemDefinition::type)
    ;
}

#endif
