//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_ValueItem_h
#define pybind_attribute_ValueItem_h

#include <memory>
#include <pybind11/pybind11.h>

#include "smtk/attribute/ValueItem.h"
#include "smtk/attribute/RefItem.h"

namespace py = pybind11;

py::class_<smtk::attribute::ValueItem, std::shared_ptr<smtk::attribute::ValueItem> >
pybind11_init_smtk_attribute_ValueItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> > &parent)
{
  py::class_<smtk::attribute::ValueItem, std::shared_ptr<smtk::attribute::ValueItem> > instance(m, "ValueItem", parent);
  instance
    .def_property("numberOfValues", &smtk::attribute::ValueItem::numberOfValues, &smtk::attribute::ValueItem::setNumberOfValues)
    .def("activeChildItem", &smtk::attribute::ValueItem::activeChildItem, py::arg("i"))
    .def("allowsExpressions", &smtk::attribute::ValueItem::allowsExpressions)
    .def("appendExpression", &smtk::attribute::ValueItem::appendExpression, py::arg("exp"))
    .def("assign", &smtk::attribute::ValueItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("childrenItems", &smtk::attribute::ValueItem::childrenItems)
    .def("classname", &smtk::attribute::ValueItem::classname)
    .def("discreteIndex", &smtk::attribute::ValueItem::discreteIndex, py::arg("elementIndex") = 0)
    .def("expression", &smtk::attribute::ValueItem::expression, py::arg("elementIndex") = 0)
    .def("expressionReference", &smtk::attribute::ValueItem::expressionReference, py::arg("elementIndex") = 0)
    .def("findChild", (smtk::attribute::ItemPtr (smtk::attribute::ValueItem::*)(::std::string const &, ::smtk::attribute::SearchStyle)) &smtk::attribute::ValueItem::findChild)
    .def("findChild", (smtk::attribute::ConstItemPtr (smtk::attribute::ValueItem::*)(::std::string const &, ::smtk::attribute::SearchStyle) const) &smtk::attribute::ValueItem::findChild)
    .def("hasDefault", &smtk::attribute::ValueItem::hasDefault)
    .def("isDiscrete", &smtk::attribute::ValueItem::isDiscrete)
    .def("isDiscreteIndexValid", &smtk::attribute::ValueItem::isDiscreteIndexValid, py::arg("value"))
    .def("isExpression", &smtk::attribute::ValueItem::isExpression, py::arg("elementIndex") = 0)
    .def("isExtensible", &smtk::attribute::ValueItem::isExtensible)
    .def("isSet", &smtk::attribute::ValueItem::isSet, py::arg("elementIndex") = 0)
    .def("isUsingDefault", (bool (smtk::attribute::ValueItem::*)(::size_t) const) &smtk::attribute::ValueItem::isUsingDefault)
    .def("isUsingDefault", (bool (smtk::attribute::ValueItem::*)() const) &smtk::attribute::ValueItem::isUsingDefault)
    .def("isValid", &smtk::attribute::ValueItem::isValid)
    .def("maxNumberOfValues", &smtk::attribute::ValueItem::maxNumberOfValues)
    .def("numberOfActiveChildrenItems", &smtk::attribute::ValueItem::numberOfActiveChildrenItems)
    .def("numberOfChildrenItems", &smtk::attribute::ValueItem::numberOfChildrenItems)
    .def("numberOfRequiredValues", &smtk::attribute::ValueItem::numberOfRequiredValues)
    .def("reset", &smtk::attribute::ValueItem::reset)
    .def("setDiscreteIndex", (bool (smtk::attribute::ValueItem::*)(int)) &smtk::attribute::ValueItem::setDiscreteIndex)
    .def("setDiscreteIndex", (bool (smtk::attribute::ValueItem::*)(::size_t, int)) &smtk::attribute::ValueItem::setDiscreteIndex)
    .def("setExpression", (bool (smtk::attribute::ValueItem::*)(::smtk::attribute::AttributePtr)) &smtk::attribute::ValueItem::setExpression)
    .def("setExpression", (bool (smtk::attribute::ValueItem::*)(::size_t, ::smtk::attribute::AttributePtr)) &smtk::attribute::ValueItem::setExpression)
    .def("setToDefault", &smtk::attribute::ValueItem::setToDefault, py::arg("elementIndex") = 0)
    .def("unset", &smtk::attribute::ValueItem::unset, py::arg("elementIndex") = 0)
    .def("valueAsString", (std::string (smtk::attribute::ValueItem::*)() const) &smtk::attribute::ValueItem::valueAsString)
    .def("valueAsString", (std::string (smtk::attribute::ValueItem::*)(::size_t) const) &smtk::attribute::ValueItem::valueAsString)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::Item> i) {
        return std::dynamic_pointer_cast<smtk::attribute::ValueItem>(i);
      })
    ;
  return instance;
}

#endif
