//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_StringItemDefinition_h
#define pybind_attribute_StringItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/StringItemDefinition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_StringItemDefinition(py::module &m, py::class_<smtk::attribute::ValueItemDefinitionTemplate<std::string>, std::shared_ptr<smtk::attribute::ValueItemDefinitionTemplate<std::string> > >& parent)
{
  py::class_<smtk::attribute::StringItemDefinition, std::shared_ptr<smtk::attribute::StringItemDefinition> > instance(m, "StringItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::StringItemDefinition const &>())
    .def_property("isMultiline", &smtk::attribute::StringItemDefinition::isMultiline, &smtk::attribute::StringItemDefinition::setIsMultiline)
    .def_property("isSecure", &smtk::attribute::StringItemDefinition::isSecure, &smtk::attribute::StringItemDefinition::setIsSecure)
    .def_static("New", &smtk::attribute::StringItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::StringItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::StringItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::StringItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::StringItemDefinition::buildItem)
    .def("classname", &smtk::attribute::StringItemDefinition::classname)
    .def("createCopy", &smtk::attribute::StringItemDefinition::createCopy, py::arg("info"))
    .def("type", &smtk::attribute::StringItemDefinition::type)
    .def_static("ToItemDefinition", [](const std::shared_ptr<smtk::attribute::StringItemDefinition> d) {
        return std::dynamic_pointer_cast<smtk::attribute::ItemDefinition>(d);
      })
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::StringItemDefinition>(i);
      })
    ;
}

#endif
