//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_StringItem_h
#define pybind_attribute_StringItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/StringItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_StringItem(py::module &m, py::class_<smtk::attribute::ValueItemTemplate<std::string>, std::shared_ptr<smtk::attribute::ValueItemTemplate<std::string> > >& parent)
{
  py::class_<smtk::attribute::StringItem, std::shared_ptr<smtk::attribute::StringItem> > instance(m, "StringItem", parent);
  instance
    .def(py::init<::smtk::attribute::StringItem const &>())
    .def("assign", &smtk::attribute::StringItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("classname", &smtk::attribute::StringItem::classname)
    .def("isSecure", &smtk::attribute::StringItem::isSecure)
    .def("type", &smtk::attribute::StringItem::type)
    ;
}

#endif
