//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_RefItemDefinition_h
#define pybind_attribute_RefItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/RefItemDefinition.h"
#include "smtk/attribute/Definition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_RefItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::RefItemDefinition, std::shared_ptr<smtk::attribute::RefItemDefinition> > instance(m, "RefItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::RefItemDefinition const &>())
    .def_property("valueLabel", &smtk::attribute::RefItemDefinition::valueLabel, &smtk::attribute::RefItemDefinition::setValueLabel)
    .def_property("attributeDefinition", &smtk::attribute::RefItemDefinition::attributeDefinition, &smtk::attribute::RefItemDefinition::setAttributeDefinition)
    .def_property("numberOfRequiredValues", &smtk::attribute::RefItemDefinition::numberOfRequiredValues, &smtk::attribute::RefItemDefinition::setNumberOfRequiredValues)
    .def_static("New", &smtk::attribute::RefItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::RefItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::RefItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::RefItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::RefItemDefinition::buildItem)
    .def("classname", &smtk::attribute::RefItemDefinition::classname)
    .def("createCopy", &smtk::attribute::RefItemDefinition::createCopy, py::arg("info"))
    .def("hasValueLabels", &smtk::attribute::RefItemDefinition::hasValueLabels)
    .def("isValueValid", &smtk::attribute::RefItemDefinition::isValueValid, py::arg("att"))
    .def("setCommonValueLabel", &smtk::attribute::RefItemDefinition::setCommonValueLabel, py::arg("elabel"))
    .def("type", &smtk::attribute::RefItemDefinition::type)
    .def("usingCommonLabel", &smtk::attribute::RefItemDefinition::usingCommonLabel)
    .def_static("ToItemDefinition", [](smtk::shared_ptr<smtk::attribute::RefItemDefinition> d) {
        return smtk::dynamic_pointer_cast<smtk::attribute::ItemDefinition>(d);
      })
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::RefItemDefinition>(i);
      })
    ;
}

#endif
