//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_RefItem_h
#define pybind_attribute_RefItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/RefItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_RefItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> >& parent)
{
  py::class_<smtk::attribute::RefItem, std::shared_ptr<smtk::attribute::RefItem> > instance(m, "RefItem", parent);
  instance
    .def(py::init<::smtk::attribute::RefItem const &>())
    .def("deepcopy", (smtk::attribute::RefItem & (smtk::attribute::RefItem::*)(::smtk::attribute::RefItem const &)) &smtk::attribute::RefItem::operator=)
    .def_property("numberOfValues", &smtk::attribute::RefItem::numberOfValues, &smtk::attribute::RefItem::setNumberOfValues)
    .def("appendValue", &smtk::attribute::RefItem::appendValue, py::arg("val"))
    .def("assign", &smtk::attribute::RefItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("begin", &smtk::attribute::RefItem::begin)
    .def("classname", &smtk::attribute::RefItem::classname)
    .def("end", &smtk::attribute::RefItem::end)
    .def("isSet", &smtk::attribute::RefItem::isSet, py::arg("element") = 0)
    .def("isValid", &smtk::attribute::RefItem::isValid)
    .def("numberOfRequiredValues", &smtk::attribute::RefItem::numberOfRequiredValues)
    .def("removeValue", &smtk::attribute::RefItem::removeValue, py::arg("element"))
    .def("reset", &smtk::attribute::RefItem::reset)
    .def("setValue", (bool (smtk::attribute::RefItem::*)(::smtk::attribute::AttributePtr)) &smtk::attribute::RefItem::setValue)
    .def("setValue", (bool (smtk::attribute::RefItem::*)(::size_t, ::smtk::attribute::AttributePtr)) &smtk::attribute::RefItem::setValue)
    .def("type", &smtk::attribute::RefItem::type)
    .def("unset", &smtk::attribute::RefItem::unset, py::arg("element") = 0)
    .def("value", &smtk::attribute::RefItem::value, py::arg("element") = 0)
    .def("valueAsString", (std::string (smtk::attribute::RefItem::*)(::std::string const &) const) &smtk::attribute::RefItem::valueAsString)
    .def("valueAsString", (std::string (smtk::attribute::RefItem::*)(::size_t, ::std::string const &) const) &smtk::attribute::RefItem::valueAsString)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::Item> i) {
        return std::dynamic_pointer_cast<smtk::attribute::RefItem>(i);
      })
    ;
}

#endif
