//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_MeshSelectionItemDefinition_h
#define pybind_attribute_MeshSelectionItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/MeshSelectionItemDefinition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_MeshSelectionItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::MeshSelectionItemDefinition, std::shared_ptr<smtk::attribute::MeshSelectionItemDefinition> > instance(m, "MeshSelectionItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::MeshSelectionItemDefinition const &>())
    .def_property("membershipMask", &smtk::attribute::MeshSelectionItemDefinition::membershipMask, &smtk::attribute::MeshSelectionItemDefinition::setMembershipMask)
    .def_property("refModelEntityName", &smtk::attribute::MeshSelectionItemDefinition::refModelEntityName, &smtk::attribute::MeshSelectionItemDefinition::setRefModelEntityName)
    .def_property("modifyMode", &smtk::attribute::MeshSelectionItemDefinition::modifyMode, &smtk::attribute::MeshSelectionItemDefinition::setModifyMode)
    .def_static("New", &smtk::attribute::MeshSelectionItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::MeshSelectionItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::MeshSelectionItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::MeshSelectionItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::MeshSelectionItemDefinition::buildItem)
    .def("classname", &smtk::attribute::MeshSelectionItemDefinition::classname)
    .def("createCopy", &smtk::attribute::MeshSelectionItemDefinition::createCopy, py::arg("info"))
    .def("isValueValid", &smtk::attribute::MeshSelectionItemDefinition::isValueValid, py::arg("val"))
    .def("type", &smtk::attribute::MeshSelectionItemDefinition::type)
    ;
}

#endif
