//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_MeshSelectionItem_h
#define pybind_attribute_MeshSelectionItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/MeshSelectionItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_MeshSelectionItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> >& parent)
{
  py::class_<smtk::attribute::MeshSelectionItem, std::shared_ptr<smtk::attribute::MeshSelectionItem> > instance(m, "MeshSelectionItem", parent);
  instance
    .def(py::init<::smtk::attribute::MeshSelectionItem const &>())
    .def("deepcopy", (smtk::attribute::MeshSelectionItem & (smtk::attribute::MeshSelectionItem::*)(::smtk::attribute::MeshSelectionItem const &)) &smtk::attribute::MeshSelectionItem::operator=)
    .def_property("modifyMode", &smtk::attribute::MeshSelectionItem::modifyMode, &smtk::attribute::MeshSelectionItem::setModifyMode)
    .def("values", &smtk::attribute::MeshSelectionItem::values)
    .def("setValues", &smtk::attribute::MeshSelectionItem::setValues)
    .def("assign", &smtk::attribute::MeshSelectionItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("begin", &smtk::attribute::MeshSelectionItem::begin)
    .def("classname", &smtk::attribute::MeshSelectionItem::classname)
    .def("end", &smtk::attribute::MeshSelectionItem::end)
    .def("isCtrlKeyDown", &smtk::attribute::MeshSelectionItem::isCtrlKeyDown)
    .def("isValid", &smtk::attribute::MeshSelectionItem::isValid)
    .def_static("modifyMode2String", &smtk::attribute::MeshSelectionItem::modifyMode2String, py::arg("m"))
    .def("numberOfValues", &smtk::attribute::MeshSelectionItem::numberOfValues)
    .def("removeValues", &smtk::attribute::MeshSelectionItem::removeValues, py::arg("arg0"), py::arg("arg1"))
    .def("reset", &smtk::attribute::MeshSelectionItem::reset)
    .def("setCtrlKeyDown", &smtk::attribute::MeshSelectionItem::setCtrlKeyDown, py::arg("val"))
    .def_static("string2ModifyMode", &smtk::attribute::MeshSelectionItem::string2ModifyMode, py::arg("s"))
    .def("type", &smtk::attribute::MeshSelectionItem::type)
    .def("unionValues", &smtk::attribute::MeshSelectionItem::unionValues, py::arg("arg0"), py::arg("arg1"))
    ;
}

#endif
