//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_MeshItemDefinition_h
#define pybind_attribute_MeshItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/MeshItemDefinition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_MeshItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::MeshItemDefinition, std::shared_ptr<smtk::attribute::MeshItemDefinition> > instance(m, "MeshItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::MeshItemDefinition const &>())
    .def_property("isExtensible", &smtk::attribute::MeshItemDefinition::isExtensible, &smtk::attribute::MeshItemDefinition::setIsExtensible)
    .def_property("maxNumberOfValues", &smtk::attribute::MeshItemDefinition::maxNumberOfValues, &smtk::attribute::MeshItemDefinition::setMaxNumberOfValues)
    .def_property("numberOfRequiredValues", &smtk::attribute::MeshItemDefinition::numberOfRequiredValues, &smtk::attribute::MeshItemDefinition::setNumberOfRequiredValues)
    .def_static("New", &smtk::attribute::MeshItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::MeshItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::MeshItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::MeshItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::MeshItemDefinition::buildItem)
    .def("classname", &smtk::attribute::MeshItemDefinition::classname)
    .def("createCopy", &smtk::attribute::MeshItemDefinition::createCopy, py::arg("info"))
    .def("isValueValid", &smtk::attribute::MeshItemDefinition::isValueValid, py::arg("val"))
    .def("type", &smtk::attribute::MeshItemDefinition::type)
    ;
}

#endif
