//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_IntItemDefinition_h
#define pybind_attribute_IntItemDefinition_h

#include <memory>

#include <pybind11/pybind11.h>

#include "smtk/attribute/IntItemDefinition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_IntItemDefinition(py::module &m, py::class_<smtk::attribute::ValueItemDefinitionTemplate<int>, std::shared_ptr<smtk::attribute::ValueItemDefinitionTemplate<int> > >& parent)
{
  py::class_<smtk::attribute::IntItemDefinition, std::shared_ptr<smtk::attribute::IntItemDefinition> > instance(m, "IntItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::IntItemDefinition const &>())
    .def_static("New", &smtk::attribute::IntItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::IntItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::IntItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::IntItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::IntItemDefinition::buildItem)
    .def("classname", &smtk::attribute::IntItemDefinition::classname)
    .def("createCopy", &smtk::attribute::IntItemDefinition::createCopy, py::arg("info"))
    .def("type", &smtk::attribute::IntItemDefinition::type)
    .def_static("ToItemDefinition", [](const std::shared_ptr<smtk::attribute::IntItemDefinition> d) {
        return std::dynamic_pointer_cast<smtk::attribute::ItemDefinition>(d);
      })
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::IntItemDefinition>(i);
      })
    ;
}

#endif
