//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_IntItem_h
#define pybind_attribute_IntItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/IntItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_IntItem(py::module &m, py::class_<smtk::attribute::ValueItemTemplate<int>, std::shared_ptr<smtk::attribute::ValueItemTemplate<int> > >& parent)
{
  py::class_<smtk::attribute::IntItem, std::shared_ptr<smtk::attribute::IntItem> > instance(m, "IntItem", parent);
  instance
    .def(py::init<::smtk::attribute::IntItem const &>())
    .def("assign", &smtk::attribute::IntItem::assign, py::arg("sourceItem"), py::arg("options") = 0)
    .def("classname", &smtk::attribute::IntItem::classname)
    .def("type", &smtk::attribute::IntItem::type)
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::Item> i) {
        return std::dynamic_pointer_cast<smtk::attribute::IntItem>(i);
      })
    ;
}

#endif
