//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_GroupItemDefinition_h
#define pybind_attribute_GroupItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/GroupItemDefinition.h"
#include "smtk/attribute/GroupItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_GroupItemDefinition(py::module &m, py::class_<smtk::attribute::ItemDefinition, std::shared_ptr<smtk::attribute::ItemDefinition> >& parent)
{
  py::class_<smtk::attribute::GroupItemDefinition, std::shared_ptr<smtk::attribute::GroupItemDefinition> > instance(m, "GroupItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::GroupItemDefinition const &>())
    .def_property("isExtensible", &smtk::attribute::GroupItemDefinition::isExtensible, &smtk::attribute::GroupItemDefinition::setIsExtensible)
    .def_property("subGroupLabel", &smtk::attribute::GroupItemDefinition::subGroupLabel, &smtk::attribute::GroupItemDefinition::setSubGroupLabel)
    .def_property("maxNumberOfGroups", &smtk::attribute::GroupItemDefinition::maxNumberOfGroups, &smtk::attribute::GroupItemDefinition::setMaxNumberOfGroups)
    .def_property("numberOfRequiredGroups", &smtk::attribute::GroupItemDefinition::numberOfRequiredGroups, &smtk::attribute::GroupItemDefinition::setNumberOfRequiredGroups)
    .def_static("New", &smtk::attribute::GroupItemDefinition::New, py::arg("myName"))
    .def("addCategory", &smtk::attribute::GroupItemDefinition::addCategory, py::arg("category"))
    .def("addItemDefinition", (bool (smtk::attribute::GroupItemDefinition::*)(::smtk::attribute::ItemDefinitionPtr)) &smtk::attribute::GroupItemDefinition::addItemDefinition, py::arg("cdef"))
    .def("buildGroup", &smtk::attribute::GroupItemDefinition::buildGroup, py::arg("group"), py::arg("subGroupPosition"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::GroupItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::GroupItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::GroupItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::GroupItemDefinition::buildItem)
    .def("classname", &smtk::attribute::GroupItemDefinition::classname)
    .def("createCopy", &smtk::attribute::GroupItemDefinition::createCopy, py::arg("info"))
    .def("findItemPosition", &smtk::attribute::GroupItemDefinition::findItemPosition, py::arg("name"))
    .def("hasSubGroupLabels", &smtk::attribute::GroupItemDefinition::hasSubGroupLabels)
    .def("itemDefinition", &smtk::attribute::GroupItemDefinition::itemDefinition, py::arg("ith"))
    .def("numberOfItemDefinitions", &smtk::attribute::GroupItemDefinition::numberOfItemDefinitions)
    .def("removeCategory", &smtk::attribute::GroupItemDefinition::removeCategory, py::arg("category"))
    .def("setCommonSubGroupLabel", &smtk::attribute::GroupItemDefinition::setCommonSubGroupLabel, py::arg("elabel"))
    .def("type", &smtk::attribute::GroupItemDefinition::type)
    .def("usingCommonSubGroupLabel", &smtk::attribute::GroupItemDefinition::usingCommonSubGroupLabel)
    .def_static("ToItemDefinition", [](const std::shared_ptr<smtk::attribute::GroupItemDefinition> d) {
        return std::dynamic_pointer_cast<smtk::attribute::ItemDefinition>(d);
      })
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::GroupItemDefinition>(i);
      })
    ;
}

#endif
