//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_DoubleItemDefinition_h
#define pybind_attribute_DoubleItemDefinition_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/DoubleItemDefinition.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_DoubleItemDefinition(py::module &m, py::class_<smtk::attribute::ValueItemDefinitionTemplate<double>, std::shared_ptr<smtk::attribute::ValueItemDefinitionTemplate<double> > >& parent)
{
  py::class_<smtk::attribute::DoubleItemDefinition, std::shared_ptr<smtk::attribute::DoubleItemDefinition> > instance(m, "DoubleItemDefinition", parent);
  instance
    .def(py::init<::smtk::attribute::DoubleItemDefinition const &>())
    .def_static("New", &smtk::attribute::DoubleItemDefinition::New, py::arg("myName"))
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::DoubleItemDefinition::*)(::smtk::attribute::Attribute *, int) const) &smtk::attribute::DoubleItemDefinition::buildItem)
    .def("buildItem", (smtk::attribute::ItemPtr (smtk::attribute::DoubleItemDefinition::*)(::smtk::attribute::Item *, int, int) const) &smtk::attribute::DoubleItemDefinition::buildItem)
    .def("classname", &smtk::attribute::DoubleItemDefinition::classname)
    .def("createCopy", &smtk::attribute::DoubleItemDefinition::createCopy, py::arg("info"))
    .def("type", &smtk::attribute::DoubleItemDefinition::type)
    .def_static("ToItemDefinition", [](const std::shared_ptr<smtk::attribute::DoubleItemDefinition> d) {
        return std::dynamic_pointer_cast<smtk::attribute::ItemDefinition>(d);
      })
    .def_static("CastTo", [](const std::shared_ptr<smtk::attribute::ItemDefinition> i) {
        return std::dynamic_pointer_cast<smtk::attribute::DoubleItemDefinition>(i);
      })
    ;
}

#endif
