//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_model_SubphraseGenerator_h
#define pybind_smtk_model_SubphraseGenerator_h

#include <pybind11/pybind11.h>

#include "smtk/model/SubphraseGenerator.h"

namespace py = pybind11;

PySharedPtrClass< smtk::model::SubphraseGenerator > pybind11_init_smtk_model_SubphraseGenerator(py::module &m)
{
  PySharedPtrClass< smtk::model::SubphraseGenerator > instance(m, "SubphraseGenerator");
  instance
    .def(py::init<::smtk::model::SubphraseGenerator const &>())
    .def("deepcopy", (smtk::model::SubphraseGenerator & (smtk::model::SubphraseGenerator::*)(::smtk::model::SubphraseGenerator const &)) &smtk::model::SubphraseGenerator::operator=)
    .def_property("skipProperties", &smtk::model::SubphraseGenerator::skipProperties, &smtk::model::SubphraseGenerator::setSkipProperties)
    .def_property("directLimit", &smtk::model::SubphraseGenerator::directLimit, &smtk::model::SubphraseGenerator::setDirectLimit)
    .def_property("skipAttributes", &smtk::model::SubphraseGenerator::skipAttributes, &smtk::model::SubphraseGenerator::setSkipAttributes)
    .def("classname", &smtk::model::SubphraseGenerator::classname)
    .def("shouldOmitProperty", &smtk::model::SubphraseGenerator::shouldOmitProperty, py::arg("parent"), py::arg("ptype"), py::arg("pname"))
    .def("subphrases", &smtk::model::SubphraseGenerator::subphrases, py::arg("src"))
    ;
  return instance;
}

#endif
