//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_model_Session_h
#define pybind_smtk_model_Session_h

#include <pybind11/pybind11.h>

#include "smtk/model/Session.h"

namespace py = pybind11;

PySharedPtrClass< smtk::model::Session > pybind11_init_smtk_model_Session(py::module &m)
{
  PySharedPtrClass< smtk::model::Session > instance(m, "Session");
  instance
    .def(py::init<::smtk::model::Session const &>())
    .def("deepcopy", (smtk::model::Session & (smtk::model::Session::*)(::smtk::model::Session const &)) &smtk::model::Session::operator=)
    .def("allSupportedInformation", &smtk::model::Session::allSupportedInformation)
    .def("className", &smtk::model::Session::className)
    .def("classname", &smtk::model::Session::classname)
    .def("danglingEntities", &smtk::model::Session::danglingEntities)
    .def("declareDanglingEntity", &smtk::model::Session::declareDanglingEntity, py::arg("ent"), py::arg("present") = 0)
    // This method passes around a bare pointer
    // .def("findOperatorConstructor", &smtk::model::Session::findOperatorConstructor, py::arg("opName"))
    .def("findOperatorXML", &smtk::model::Session::findOperatorXML, py::arg("opName"))
    .def("inheritsOperators", &smtk::model::Session::inheritsOperators)
    .def("log", &smtk::model::Session::log)
    .def("manager", &smtk::model::Session::manager)
    .def("meshManager", &smtk::model::Session::meshManager)
    .def("name", &smtk::model::Session::name)
    .def("op", &smtk::model::Session::op, py::arg("opName"))
    .def("operatorLabelsMap", &smtk::model::Session::operatorLabelsMap, py::arg("includeAdvanced") = true)
    .def("operatorNames", &smtk::model::Session::operatorNames, py::arg("includeAdvanced") = true)
    .def("operatorSystem", (smtk::attribute::System * (smtk::model::Session::*)()) &smtk::model::Session::operatorSystem)
    .def("operatorSystem", (smtk::attribute::System const * (smtk::model::Session::*)() const) &smtk::model::Session::operatorSystem)
    .def("registerOperator", &smtk::model::Session::registerOperator, py::arg("opName"), py::arg("opDescrXML"), py::arg("opCtor"))
    .def_static("registerStaticOperator", &smtk::model::Session::registerStaticOperator, py::arg("opName"), py::arg("opDescrXML"), py::arg("opCtor"))
    .def("sessionId", &smtk::model::Session::sessionId)
    .def("setup", &smtk::model::Session::setup, py::arg("optName"), py::arg("optVal"))
    .def_static("staticClassName", &smtk::model::Session::staticClassName)
    .def("transcribe", &smtk::model::Session::transcribe, py::arg("entity"), py::arg("flags"), py::arg("onlyDangling") = true, py::arg("depth") = -1)
    ;
  return instance;
}

#endif
