//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#include <pybind11/pybind11.h>

#include "PybindEnvironment.h"
#include "PybindFileLocation.h"
#include "PybindPaths.h"
#if !defined(_WIN32) || defined(__CYGWIN__)
#include "PybindPathsHelperUnix.h"
#  ifdef __APPLE__
#include "PybindPathsHelperMacOSX.h"
#  endif
#else
#include "PybindPathsHelperWindows.h"
#endif
#include "PybindResource.h"
#include "PybindResourceSet.h"
#include "PybindStringUtil.h"
#include "PybindUUID.h"
#include "PybindUUIDGenerator.h"
#include "PybindView.h"

namespace py = pybind11;

PYBIND11_PLUGIN(smtkPybindCommon)
{
  py::module common("smtkPybindCommon", "<description>");
  py::module view = common.def_submodule("view", "<description>");

  // The order of these function calls is important! It was determined by
  // comparing the dependencies of each of the wrapped objects.
  pybind11_init_smtk_common_FileLocation(common);
#if !defined(_WIN32) || defined(__CYGWIN__)
  pybind11_init_smtk_common_PathsHelperUnix(common);
#  ifdef __APPLE__
  pybind11_init_smtk_common_PathsHelperMacOSX(common);
#  endif
#else
  pybind11_init_smtk_common_PathsHelperWindows(common);
#endif
  pybind11_init_smtk_common_StringUtil(common);
  pybind11_init_smtk_common_View_Component(view);
  pybind11_init_smtk_common_Environment(common);
  pybind11_init_smtk_common_UUID(common);
  pybind11_init_smtk_common_View(common);
  pybind11_init_smtk_common_Paths(common);
  pybind11_init_smtk_common_UUIDGenerator(common);
  pybind11_init_smtk_common_ResourceSet(common);
  pybind11_init_smtk_common_Resource(common);

  return common.ptr();
}
