//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_bridge_polygon_operators_ImportImage_h
#define pybind_smtk_bridge_polygon_operators_ImportImage_h

#include <pybind11/pybind11.h>

#include "smtk/bridge/polygon/operators/ImportImage.h"

namespace py = pybind11;

PySharedPtrClass< smtk::bridge::polygon::ImportImage > pybind11_init_smtk_bridge_polygon_ImportImage(py::module &m, PySharedPtrClass< smtk::bridge::polygon::Operator, smtk::model::Operator >& parent)
{
  PySharedPtrClass< smtk::bridge::polygon::ImportImage > instance(m, "ImportImage", parent);
  instance
    .def(py::init<::smtk::bridge::polygon::ImportImage const &>())
    .def("deepcopy", (smtk::bridge::polygon::ImportImage & (smtk::bridge::polygon::ImportImage::*)(::smtk::bridge::polygon::ImportImage const &)) &smtk::bridge::polygon::ImportImage::operator=)
    .def("ableToOperate", &smtk::bridge::polygon::ImportImage::ableToOperate)
    .def_static("baseCreate", &smtk::bridge::polygon::ImportImage::baseCreate)
    .def("className", &smtk::bridge::polygon::ImportImage::className)
    .def("classname", &smtk::bridge::polygon::ImportImage::classname)
    .def_static("create", (std::shared_ptr<smtk::bridge::polygon::ImportImage> (*)()) &smtk::bridge::polygon::ImportImage::create)
    .def_static("create", (std::shared_ptr<smtk::bridge::polygon::ImportImage> (*)(::std::shared_ptr<smtk::bridge::polygon::ImportImage> &)) &smtk::bridge::polygon::ImportImage::create, py::arg("ref"))
    .def("name", &smtk::bridge::polygon::ImportImage::name)
    .def("shared_from_this", (std::shared_ptr<const smtk::bridge::polygon::ImportImage> (smtk::bridge::polygon::ImportImage::*)() const) &smtk::bridge::polygon::ImportImage::shared_from_this)
    .def("shared_from_this", (std::shared_ptr<smtk::bridge::polygon::ImportImage> (smtk::bridge::polygon::ImportImage::*)()) &smtk::bridge::polygon::ImportImage::shared_from_this)
    ;
  return instance;
}

#endif
