//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_smtk_bridge_discrete_BathymetryHelper_h
#define pybind_smtk_bridge_discrete_BathymetryHelper_h

#include <pybind11/pybind11.h>

#include "smtk/bridge/discrete/BathymetryHelper.h"

#include "smtk/mesh/Collection.h"
#include "smtk/mesh/ForEachTypes.h"

#include "vtkPoints.h"
#include "vtkPolyData.h"

namespace py = pybind11;

py::class_< smtk::bridge::discrete::BathymetryHelper > pybind11_init_smtk_bridge_discrete_BathymetryHelper(py::module &m)
{
  py::class_< smtk::bridge::discrete::BathymetryHelper > instance(m, "BathymetryHelper");
  instance
    .def("addModelBathymetry", &smtk::bridge::discrete::BathymetryHelper::addModelBathymetry, py::arg("modelId"), py::arg("bathyfile"))
    .def("bathymetryData", &smtk::bridge::discrete::BathymetryHelper::bathymetryData, py::arg("filename"))
    .def("cachedMeshPointsZ", &smtk::bridge::discrete::BathymetryHelper::cachedMeshPointsZ, py::arg("collectionId"))
    .def("classname", &smtk::bridge::discrete::BathymetryHelper::classname)
    .def("clear", &smtk::bridge::discrete::BathymetryHelper::clear)
    .def("computeBathymetryPoints", &smtk::bridge::discrete::BathymetryHelper::computeBathymetryPoints, py::arg("input"), py::arg("output"))
    .def("findOrShallowCopyModelPoly", &smtk::bridge::discrete::BathymetryHelper::findOrShallowCopyModelPoly, py::arg("modelId"), py::arg("session"))
    .def("hasModelBathymetry", &smtk::bridge::discrete::BathymetryHelper::hasModelBathymetry, py::arg("modelId"))
    .def("loadBathymetryFile", &smtk::bridge::discrete::BathymetryHelper::loadBathymetryFile, py::arg("filename"))
    .def("loadedBathymetryFiles", &smtk::bridge::discrete::BathymetryHelper::loadedBathymetryFiles, py::arg("result"))
    .def("removeModelBathymetry", &smtk::bridge::discrete::BathymetryHelper::removeModelBathymetry, py::arg("modelId"))
    .def("resetMeshPointsZ", &smtk::bridge::discrete::BathymetryHelper::resetMeshPointsZ, py::arg("collection"))
    .def("storeMeshPointsZ", &smtk::bridge::discrete::BathymetryHelper::storeMeshPointsZ, py::arg("collection"))
    ;
  return instance;
}

py::class_< smtk::bridge::discrete::ZValueHelper, smtk::mesh::PointForEach > pybind11_init_smtk_bridge_discrete_ZValueHelper(py::module &m)
{
  py::class_< smtk::bridge::discrete::ZValueHelper, smtk::mesh::PointForEach > instance(m, "ZValueHelper");
  instance
    .def(py::init<::smtk::bridge::discrete::ZValueHelper const &>())
    .def(py::init<::std::vector<double, std::allocator<double> > &, bool>())
    .def("forPoints", &smtk::bridge::discrete::ZValueHelper::forPoints, py::arg("pointIds"), py::arg("xyz"), py::arg("coordinatesModified"))
    ;
  return instance;
}

#endif
