//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//=========================================================================

#ifndef pybind_attribute_VoidItem_h
#define pybind_attribute_VoidItem_h

#include <pybind11/pybind11.h>

#include "smtk/attribute/VoidItem.h"

namespace py = pybind11;

void pybind11_init_smtk_attribute_VoidItem(py::module &m, py::class_<smtk::attribute::Item, std::shared_ptr<smtk::attribute::Item> >& parent)
{
  py::class_<smtk::attribute::VoidItem, std::shared_ptr<smtk::attribute::VoidItem> > instance(m, "VoidItem", parent);
  instance
    .def(py::init<::smtk::attribute::VoidItem const &>())
    .def("deepcopy", (smtk::attribute::VoidItem & (smtk::attribute::VoidItem::*)(::smtk::attribute::VoidItem const &)) &smtk::attribute::VoidItem::operator=)
    .def("classname", &smtk::attribute::VoidItem::classname)
    .def("isValid", &smtk::attribute::VoidItem::isValid)
    .def("type", &smtk::attribute::VoidItem::type)
    ;
}

#endif
